﻿using HIPS.CommonSchemas;
using HIPS.PcehrDataStore.Schemas;

namespace HIPS.PcehrSchemas
{
    /// <summary>
    /// The result of an individual operation status query.
    /// </summary>
    public class IndividualOperationStatus
    {
        private ClinicalDocument clinicalDocument = new ClinicalDocument();
        private byte[] decodedPackage = null;
        private PcehrMessageQueue queuedOperation = new PcehrMessageQueue();
        private HipsResponse response = new HipsResponse(HipsResponseIndicator.OK);

        /// <summary>
        /// Gets or sets the Clinical document from the Individual Queue Item.
        /// </summary>
        /// <value>
        /// This can be the Upload/Supersede or Removal operation
        /// </value>
        public ClinicalDocument ClinicalDocument
        {
            get
            {
                return clinicalDocument;
            }
            set
            {
                clinicalDocument = value;
            }
        }

        /// <summary>
        /// Gets or sets the decoded package that is to be uploaded from the Individual Queue Item.
        /// </summary>
        /// <value>
        /// The decoded package for an Upload or Supersede only
        /// </value>
        public byte[] DecodedPackage
        {
            get
            {
                return decodedPackage;
            }
            set
            {
                decodedPackage = value;
            }
        }

        /// <summary>
        /// Gets or sets the queued operation from the Individual Queue Item.
        /// </summary>
        /// <value>
        /// The queued operation.
        /// </value>
        public PcehrMessageQueue QueuedOperation
        {
            get
            {
                return queuedOperation;
            }
            set
            {
                queuedOperation = value;
            }
        }

        /// <summary>
        /// Gets or sets the HipsResponse.
        /// </summary>
        /// <value>
        /// The response.
        /// </value>
        public HipsResponse Response
        {
            get
            {
                return response;
            }
            set
            {
                response = value;
            }
        }
    }
}