﻿using System;
using System.Runtime.Serialization;

namespace HIPS.PcehrSchemas
{
    /// <summary>
    /// This object is used for individual message queue items populated from the PcehrMessageQueue and related tables
    /// </summary>

    [KnownType(typeof(MessageQueueItem))]
    [Serializable]
    [DataContract]
    public class MessageQueueItem
    {
        #region Properties

        private DateTime admissionDateTime;
        private Int64 cdaPackageSize;
        private string details;
        private string documentFormatCode;
        private string documentFormatDescription;
        private string documentTypeCode;
        private string documentTypeDescription;
        private int? documentTypeId;
        private int episodeId;
        private int facilityId;
        private string facilityName;
        private string ihi;
        private int patientId;
        private int pcehrMessageQueueId;
        private DateTime queueItemDateCreated;
        private int queueOperationId;
        private string queueOperationName;
        private int queueStatusId;
        private string queueStatusName;
        private Int64 requestSize;
        private string sourceSystemSetId;

        #endregion Properties

        #region Private Members

        /// <summary>
        /// Gets or sets the admission date and time of the episode. This may be a real episode or a
        /// stub created for the document upload.
        /// </summary>
        [DataMember]
        public DateTime AdmissionDateTime
        {
            get { return admissionDateTime; }
            set { admissionDateTime = value; }
        }

        /// <summary>
        /// Gets or sets the byte size of the CDA package (ZIP file)
        /// that is to be uploaded to the PCEHR system.
        /// </summary>
        [DataMember]
        public Int64 CDAPackageSize
        {
            get { return cdaPackageSize; }
            set { cdaPackageSize = value; }
        }

        /// <summary>
        /// Gets or sets details of the error that occurred. This is only populated if the queued operation has failed.
        /// </summary>
        [DataMember]
        public string Details
        {
            get { return details; }
            set { details = value; }
        }

        /// <summary>
        /// Gets or sets the code (template ID) of the document format from the DocumentFormat
        /// reference table.
        /// </summary>
        [DataMember]
        public string DocumentFormatCode
        {
            get { return documentFormatCode; }
            set { documentFormatCode = value; }
        }

        /// <summary>
        /// Gets or sets the description of the document format (template) from the DocumentFormat
        /// reference table.
        /// </summary>
        [DataMember]
        public string DocumentFormatDescription
        {
            get { return documentFormatDescription; }
            set { documentFormatDescription = value; }
        }

        /// <summary>
        /// Gets or sets the code for the document type, from the DocumentType reference table.
        /// </summary>
        [DataMember]
        public string DocumentTypeCode
        {
            get { return documentTypeCode; }
            set { documentTypeCode = value; }
        }

        /// <summary>
        /// Gets or sets the description of the document type,
        /// from the DocumentType reference table.
        /// </summary>
        [DataMember]
        public string DocumentTypeDescription
        {
            get { return documentTypeDescription; }
            set { documentTypeDescription = value; }
        }

        /// <summary>
        /// Gets or sets the primary key of the DocumentType table row
        /// determined using the "code" element in the CDA document.
        /// </summary>
        [DataMember]
        public int? DocumentTypeId
        {
            get { return documentTypeId; }
            set { documentTypeId = value; }
        }

        /// <summary>
        /// Gets or sets the primary key of the Episode table row. The episode record will be a stub
        /// if the ValidatedIhi patient identifier was supplied and there was no actual admission
        /// at the specified date and time.
        /// </summary>
        [DataMember]
        public int EpisodeId
        {
            get { return episodeId; }
            set { episodeId = value; }
        }

        /// <summary>
        /// Gets or sets the database primary key of the Hospital table row for the facility.
        /// </summary>
        [DataMember]
        public int FacilityId
        {
            get { return facilityId; }
            set { facilityId = value; }
        }

        /// <summary>
        /// Gets or sets the readable name of the hospital facility.
        /// </summary>
        [DataMember]
        public string FacilityName
        {
            get { return facilityName; }
            set { facilityName = value; }
        }

        /// <summary>
        /// Gets or sets the IHI of the patient.
        /// </summary>
        [DataMember]
        public string IHI
        {
            get { return ihi; }
            set { ihi = value; }
        }

        /// <summary>
        /// Gets or sets the primary key of the HospitalPatient table row for the patient.
        /// </summary>
        [DataMember]
        public int PatientId
        {
            get { return patientId; }
            set { patientId = value; }
        }

        /// <summary>
        /// Gets or sets the database primary key of the PcehrMessageQueue table row that represents this queue item.
        /// </summary>
        [DataMember]
        public int PcehrMessageQueueId
        {
            get { return pcehrMessageQueueId; }
            set { pcehrMessageQueueId = value; }
        }

        /// <summary>
        /// Gets or sets the date and time that the item was created.
        /// </summary>
        [DataMember]
        public DateTime QueueItemDateCreated
        {
            get { return queueItemDateCreated; }
            set { queueItemDateCreated = value; }
        }

        /// <summary>
        /// Gets or sets the database primary key of the QueueOperation table that identifies what type of
        /// operation it is. Upload or Supersede is 1, while Remove is 2.
        /// </summary>
        [DataMember]
        public int QueueOperationId
        {
            get { return queueOperationId; }
            set { queueOperationId = value; }
        }

        /// <summary>
        /// Gets or sets the readable name of the operation.
        /// </summary>
        [DataMember]
        public string QueueOperationName
        {
            get { return queueOperationName; }
            set { queueOperationName = value; }
        }

        /// <summary>
        /// Gets or sets the database primary key of the QueueStatus table corresponding
        /// to the queue status of this queued operation.
        /// Pending is 1, Success is 2 and Failure is 3.
        /// </summary>
        [DataMember]
        public int QueueStatusId
        {
            get { return queueStatusId; }
            set { queueStatusId = value; }
        }

        /// <summary>
        /// Gets or sets the readable name of the queue status.
        /// </summary>
        [DataMember]
        public string QueueStatusName
        {
            get { return queueStatusName; }
            set { queueStatusName = value; }
        }

        /// <summary>
        /// Gets or sets the size (in bytes) of the SOAP request. This is only populated if the queued operation has failed.
        /// </summary>
        [DataMember]
        public Int64 RequestSize
        {
            get { return requestSize; }
            set { requestSize = value; }
        }

        /// <summary>
        /// Gets or sets the serialised object. This is NOT a DataMember as it is NOT to be passed back across a Web Service call.
        /// </summary>
        public byte[] SerialisedObject { get; set; }

        /// <summary>
        /// Gets or sets the CDA document set ID.
        /// </summary>
        [DataMember]
        public string SourceSystemSetId
        {
            get { return sourceSystemSetId; }
            set { sourceSystemSetId = value; }
        }

        #endregion Private Members
    }
}