﻿using System.ServiceModel;
using HIPS.ServiceContracts.Common.DTO;
using HIPS.ServiceContracts.Common.Message;
using EntLibVal = Microsoft.Practices.EnterpriseLibrary.Validation;

using HIPS.PcehrSchemas;

namespace HIPS.ServiceContracts.AckQueue.Message
{
    /// <summary>
    /// Web service request message for the Ack Queue.
    /// </summary>
    [ServiceKnownType(typeof(RequestBase))]
    [MessageContract(WrapperNamespace = HIPS.ServiceContracts.Common.Constants.ServiceNamespace.ACK_V1)]
    public class SendAckQueueRequest : RequestBase
    {
        /// <summary>
        /// The acknowledgement to be sent to the caller.
        /// </summary>
        [MessageBodyMember(Order = 2)]
        [EntLibVal.Validators.ObjectValidator(ValidateActualType = true)]
        [EntLibVal.Validators.NotNullValidator]
        public QueuedAcknowledgementOperation Acknowledgement { get; set; }
    }
}
