﻿using System.Collections.Generic;
using System.Runtime.Serialization;

namespace HIPS.ServiceContracts.Common.DTO
{
    /// <summary>
    /// CDA Code DTO.
    /// </summary>
    [DataContract(Namespace = HIPS.ServiceContracts.Common.Constants.ServiceNamespace.COMMON_V1)]
    public class CdaCode
    {
        /// <summary>
        /// Gets or sets the code.
        /// </summary>
        [DataMember(IsRequired = true)]
        public string Code { get; set; }

        /// <summary>
        /// Gets or sets the display name for the code.
        /// </summary>
        [DataMember(IsRequired = true)]
        public string DisplayName { get; set; }
        
        /// <summary>
        /// Gets or sets the OID that represents the code system.
        /// </summary>
        [DataMember(IsRequired = true)]
        public string CodeSystem { get; set; }
        
        /// <summary>
        /// Gets or sets the name of the code system.
        /// </summary>
        [DataMember(IsRequired = true)]
        public string CodeSystemName { get; set; }        
    }
}
