﻿using System.Collections.Generic;
using System.Runtime.Serialization;

namespace HIPS.ServiceContracts.Common.DTO
{
    /// <summary>
    /// CDA Document DTO.
    /// </summary>
    [DataContract(Namespace = HIPS.ServiceContracts.Common.Constants.ServiceNamespace.COMMON_V1)]
    public class CdaDocument
    {
        /// <summary>
        /// Gets or sets the list of attachments.
        /// </summary>
        [DataMember(IsRequired = true)]
        public List<CdaAttachment> Attachments { get; set; }

        /// <summary>
        /// Gets or sets the binary content of the document.
        /// </summary>
        [DataMember(IsRequired = true)]
        public byte[] Content { get; set; }
    }
}