﻿using System.Runtime.Serialization;

using EntLibVal = Microsoft.Practices.EnterpriseLibrary.Validation;

namespace HIPS.ServiceContracts.Common.DTO.ParticipatingIndividual
{
    /// <summary>
    /// Participating Individual DTO. This class contains common fields for
    /// participating providers and consumers.
    /// </summary>
    [DataContract(Namespace = HIPS.ServiceContracts.Common.Constants.ServiceNamespace.COMMON_V1)]
    [KnownType(typeof(ParticipatingProvider))]
    public abstract class ParticipatingIndividual
    {
        /// <summary>
        /// Gets or sets the family name of the participating individual.
        /// </summary>
        [DataMember(IsRequired = true)]
        [EntLibVal.Validators.StringLengthValidator(1, 80)]
        public string FamilyName { get; set; }

        /// <summary>
        /// Gets or sets the given names of the participating individual. If
        /// there are multiple given names, they should be separated by spaces.
        /// </summary>
        [DataMember(IsRequired = true)]
        [EntLibVal.Validators.StringLengthValidator(1, 80)]
        public string GivenNames { get; set; }

        /// <summary>
        /// Gets or sets the unique local identifier of the participating
        /// individual. The local identifier must be unique within the
        /// authoring organisation (HPI-O). For the document author and
        /// responsible health professional, this is conditionally mandatory
        /// with the HPI-I as at least one must be specified.
        /// </summary>
        [DataMember(IsRequired = false)]
        [EntLibVal.Validators.StringLengthValidator(1, 40)]
        [EntLibVal.Validators.IgnoreNulls]
        public string LocalIdentifier { get; set; }

        /// <summary>
        /// Gets or sets the name suffix of the participating individual.
        /// </summary>
        [DataMember(IsRequired = false)]
        [EntLibVal.Validators.StringLengthValidator(1, 40)]
        [EntLibVal.Validators.IgnoreNulls]
        public string Suffix { get; set; }

        /// <summary>
        /// Gets or sets the name title of the participating individual.
        /// </summary>
        [DataMember(IsRequired = false)]
        [EntLibVal.Validators.StringLengthValidator(1, 40)]
        [EntLibVal.Validators.IgnoreNulls]
        public string Title { get; set; }
    }
}