﻿using System;
using System.Collections.Generic;
using System.Runtime.Serialization;

namespace HIPS.ServiceContracts.Common.Fault
{

    /// <summary>
    /// Represents an invalid document that HIPS was unable to unpackage.
    /// </summary>
    [DataContract(Namespace = HIPS.ServiceContracts.Common.Constants.ServiceNamespace.COMMON_V1)]
    public class CdaPackagingFault : FaultBase
    {

        #region Constructors

        /// <summary>
        /// Initialises a new instance of the <see cref="CdaPackagingFault" /> class.
        /// </summary>
        public CdaPackagingFault()
        {
            this.Messages = new List<Common.DTO.Message>();
        }

        #endregion

        #region Properties

        /// <summary>
        /// Gets or sets the set of messages associated with the fault.
        /// </summary>
        [DataMember]
        public virtual List<Common.DTO.Message> Messages { get; set; }

        #endregion

    }

}
