﻿using System.Runtime.Serialization;

namespace HIPS.ServiceContracts.Common.Fault
{
    /// <summary>
    /// Represents an error returned by the HI Service.
    /// </summary>
    [DataContract(Namespace = HIPS.ServiceContracts.Common.Constants.ServiceNamespace.COMMON_V1)]
    public class HiServiceFault : FaultBase
    {
        /// <summary>
        /// Gets or sets the HI Service response code.
        /// </summary>
        [DataMember]
        public string ResponseCode { get; set; }

        /// <summary>
        /// Gets or sets the HI Service response code description.
        /// </summary>
        [DataMember]
        public string ResponseCodeDescription { get; set; }

        /// <summary>
        /// Gets or sets the HI Service response code details.
        /// </summary>
        [DataMember]
        public string ResponseCodeDetails { get; set; }
    }
}