﻿using System.Runtime.Serialization;

namespace HIPS.ServiceContracts.Common.Fault
{
    /// <summary>
    /// Represents a fault when a specified item is not found in the HIPS database.
    /// </summary>
    [DataContract(Namespace = HIPS.ServiceContracts.Common.Constants.ServiceNamespace.COMMON_V1)]
    public class ItemNotFoundFault : FaultBase
    {
        /// <summary>
        /// Gets or sets the identifier value, if any, that was specified by the caller and was not able to locate the item.
        /// </summary>
        [DataMember(IsRequired = false)]
        public string Identifier { get; set; }

        /// <summary>
        /// Gets or sets the qualifier, if any, that was specified by the caller and was not able to locate the item.
        /// </summary>
        [DataMember(IsRequired = false)]
        public string Qualifier { get; set; }

        /// <summary>
        /// Gets or sets a code representing the type of item that was not found.
        /// Known examples are "Hospital", "Patient", "Episode" or "Address".
        /// </summary>
        [DataMember(IsRequired = true)]
        public string Type { get; set; }
    }
}