﻿using System;
using System.Collections.Generic;
using System.Runtime.Serialization;
using HIPS.ServiceContracts.Common;
using HIPS.ServiceContracts.Common.DTO;
using EntLibVal = Microsoft.Practices.EnterpriseLibrary.Validation;

namespace HIPS.ServiceContracts.Hpii.DTO
{
    /// <summary>
    /// HPI-I Query DTO. This abstract class represents the common components for HPI-I query,
    /// which are shared between the demographic and identifier query types.
    /// </summary>
    [DataContract(Namespace = HIPS.ServiceContracts.Common.Constants.ServiceNamespace.HPII_V2)]
    [EntLibVal.Validators.HasSelfValidation]
    public abstract class Query
    {
        #region Properties

        /// <summary>
        /// Gets or sets the family name.
        /// </summary>
        [DataMember(IsRequired = true)]
        [EntLibVal.Validators.StringLengthValidator(1, 40)]
        public string FamilyName { get; set; }

        /// <summary>
        /// Gets or sets the given names.
        /// </summary>
        [DataMember(IsRequired = false)]
        ////[EntLibVal.Validators.StringLengthValidator(1, 40)]  how to validate length of each string in a list?
        public List<string> GivenNames { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether the individual has only one name.
        /// If this field is true, the one name must be provided in the FamilyName 
        /// field and the GivenNames list must be empty.
        /// </summary>
        [DataMember(IsRequired = true)]
        public bool OnlyNameIndicator { get; set; }

        /// <summary>
        /// Gets or sets the Date of Birth.
        /// </summary>
        [DataMember(IsRequired = false)]
        [EntLibVal.Validators.IgnoreNulls]
        [EntLibVal.Validators.DateTimeRangeValidator(Constants.SupportedDates.MINIMUM, Constants.SupportedDates.MAXIMUM)]
        public DateTime? DateOfBirth { get; set; }
        
        /// <summary>
        /// Gets or sets the sex.
        /// </summary>
        [DataMember(IsRequired = false)]
        public Sex? Sex { get; set; }

        #endregion Properties

        #region Methods

        /// <summary>
        /// Validate the instance is valid.
        /// </summary>
        /// <param name="results">Validation results to add results of validation to.</param>
        [EntLibVal.Validators.SelfValidation]
        protected void Validate(EntLibVal.ValidationResults results)
        {
            if (this.OnlyNameIndicator)
            {
                if (this.GivenNames != null && this.GivenNames.Count != 0)
                {
                    results.AddResult(new EntLibVal.ValidationResult("When OnlyNameIndicator is true, the GivenNames must be empty.", this, "Query", string.Empty, null));
                }
            }
        }

        #endregion Methods
    }
}