﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;
using System.ServiceModel;
using System.Text;
using System.Threading.Tasks;

using HIPS.ServiceContracts.Common.DTO;
using HIPS.ServiceContracts.Common.Message;

using EntLibVal = Microsoft.Practices.EnterpriseLibrary.Validation;

namespace HIPS.ServiceContracts.Hpii.Message
{
    /// <summary>
    /// Web service request message for the Deactivate Local Provider operation.
    /// </summary>
    [ServiceKnownType(typeof(RequestBase))]
    public class DeactivateLocalProviderRequest : RequestBase
    {
        /// <summary>
        /// Gets or sets Hospital Identifier.
        /// </summary>
        [MessageBodyMember(Order = 2)]
        [EntLibVal.Validators.NotNullValidator]
        [EntLibVal.Validators.ObjectValidator(ValidateActualType = true)]
        public HospitalIdentifier HospitalIdentifier { get; set; }

        /// <summary>
        /// The eHISC provider identifier.
        /// </summary>
        [MessageBodyMember(Order = 3)]
        [DataMember(IsRequired = true)]
        [EntLibVal.Validators.StringLengthValidator(1, 256)]
        public string LocalProviderCode { get; set; }
        
        /// <summary>
        /// The date time from which the provider has been deactivated.
        /// </summary>
        [MessageBodyMember(Order = 4)]
        [EntLibVal.Validators.IgnoreNulls]
        public DateTime? DeactivatedDate { get; set; }
    }
}
