﻿using System.ServiceModel;

using HIPS.ServiceContracts.Common.DTO.PatientIdentifier;
using HIPS.ServiceContracts.Common.Message;

using EntLibVal = Microsoft.Practices.EnterpriseLibrary.Validation;

namespace HIPS.ServiceContracts.Patient.Message
{
    /// <summary>
    /// Web service request message for the List Patient Episodes in Hospital operation.
    /// </summary>
    [ServiceKnownType(typeof(RequestBase))]
    [MessageContract(WrapperNamespace = HIPS.ServiceContracts.Common.Constants.ServiceNamespace.PATIENT_V2)]
    public class ListPatientEpisodesInHospitalRequest : RequestBase
    {
        /// <summary>
        /// Gets or sets a value for days discharged.
        /// </summary>
        [MessageBodyMember(Order = 2)]
        [EntLibVal.Validators.NotNullValidator]
        public int DaysDischarged { get; set; }

        /// <summary>
        /// Gets or sets a value for document type code.
        /// </summary>
        [MessageBodyMember(Order = 4)]
        [EntLibVal.Validators.NotNullValidator]
        public string DocumentTypeCode { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether to include document metadata.
        /// </summary>
        [MessageBodyMember(Order = 3)]
        [EntLibVal.Validators.NotNullValidator]
        public bool IncludeDocuments { get; set; }

        /// <summary>
        /// Gets or sets an identifier of the patient and the current facility.
        /// (<see cref="Mrn">hospital MRN</see>,
        /// <see cref="StatePatientId">enterprise identifier</see>,
        /// <see cref="RegisteredEnterprisePatient">Registered Enterprise Patient</see>,
        /// <see cref="PatientMasterId">HIPS PatientMasterId</see> or
        /// <see cref="ValidatedIhi">Validated IHI</see>).
        /// </summary>
        [MessageBodyMember(Order = 1)]
        [EntLibVal.Validators.ObjectValidator(ValidateActualType = true)]
        [EntLibVal.Validators.NotNullValidator]
        public PatientIdentifierBase PatientIdentifier { get; set; }
    }
}