﻿using System.ServiceModel;

using HIPS.ServiceContracts.Common;
using HIPS.ServiceContracts.Common.DTO;
using HIPS.ServiceContracts.Common.DTO.PatientIdentifier;
using HIPS.ServiceContracts.Common.Message;

using EntLibVal = Microsoft.Practices.EnterpriseLibrary.Validation;

namespace HIPS.ServiceContracts.Pcehr.Message
{
    /// <summary>
    /// Web service request message for the Refresh Patient Participation Status operation.
    /// </summary>
    [ServiceKnownType(typeof(RequestBase))]
    [MessageContract(WrapperNamespace = HIPS.ServiceContracts.Common.Constants.ServiceNamespace.PCEHR_V2)]
    public class RefreshPatientParticipationStatusRequest : RequestBase
    {
        /// <summary>
        /// Gets or sets the Hospital Code and Hospital Code System of the facility whose
        /// healthcare provider organisation records the PCEHR disclosure status for the patient.
        /// </summary>
        [MessageBodyMember(Order = 2)]
        [EntLibVal.Validators.ObjectValidator(ValidateActualType = true)]
        public HospitalIdentifier DisclosureFacility { get; set; }

        /// <summary>
        /// Gets or sets the option of always refreshing the participation status, only if
        /// not advertised, or never refreshing the participation status.
        /// </summary>
        [MessageBodyMember(Order = 3)]
        [EntLibVal.Validators.NotNullValidator]
        public ForceRefreshOption ForceRefresh { get; set; }

        /// <summary>
        /// Gets or sets an identifier of the patient and the current facility.
        /// (<see cref="Mrn">hospital MRN</see>,
        /// <see cref="StatePatientId">enterprise identifier</see>,
        /// <see cref="RegisteredEnterprisePatient">Registered Enterprise Patient</see>,
        /// <see cref="PatientMasterId">HIPS PatientMasterId</see> or
        /// <see cref="ValidatedIhi">Validated IHI</see>).
        /// </summary>
        [MessageBodyMember(Order = 1)]
        [EntLibVal.Validators.ObjectValidator(ValidateActualType = true)]
        [EntLibVal.Validators.NotNullValidator]
        public PatientIdentifierBase PatientIdentifier { get; set; }
    }
}