﻿using System.ServiceModel;
using HIPS.CommonSchemas;

namespace HIPS.ServiceContracts.ServiceInterfaces
{
    /// <summary>
    /// Web service interface for the Database Loader service.
    /// </summary>
    [WCFExtras.Wsdl.Documentation.XmlComments]
    [ServiceContract(Namespace = "http://schemas.HIPS/Services/2012/01", Name = "DatabaseLoaderService")]
    public interface IDatabaseLoaderService
    {
        /// <summary>
        /// Notifies HIPS of an event in the Patient Administration System.
        /// This method stores the patient and episode information into the HIPS Data Store, and triggers the automatic IHI lookup and check for advertised digital health record.
        /// A failure to store the message, patient or episode will result in a negative acknowledgement being returned. 
        /// A failure to obtain an IHI or check the digital health record status will not result in a negative acknowledgement. 
        /// The IHI is not returned in the acknowledgement, but stored into the HIPS Data Store."
        /// </summary>
        /// <param name="messageForm">An HL7 message.</param>
        /// <param name="user">Details of the responsible user.</param>
        /// <returns>An HL7 acknowledgement message.</returns>
        [OperationContract]
        string NotifyPasEvent(string messageForm, UserDetails user);

        /// <summary>
        /// Notifies HIPS of a pathology result. (Not implemented)
        /// </summary>
        /// <param name="messageForm">An HL7 message.</param>
        /// <param name="user">Details of the responsible user.</param>
        /// <returns>An HL7 acknowledgement message.</returns>
        [OperationContract]
        string NotifyPathEvent(string messageForm, UserDetails user);
    }
}