
package hips;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for MessageLevel.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <p>
 * <pre>
 * &lt;simpleType name="MessageLevel">
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     &lt;enumeration value="None"/>
 *     &lt;enumeration value="Information"/>
 *     &lt;enumeration value="Warning"/>
 *     &lt;enumeration value="Error"/>
 *   &lt;/restriction>
 * &lt;/simpleType>
 * </pre>
 * 
 */
@XmlType(name = "MessageLevel")
@XmlEnum
public enum MessageLevel {


    /**
     * <summary>
     *             No level has been defined.
     *             </summary>
     * 
     */
    @XmlEnumValue("None")
    NONE("None"),

    /**
     * <summary>
     *             The message contains information.
     *             </summary>
     * 
     */
    @XmlEnumValue("Information")
    INFORMATION("Information"),

    /**
     * <summary>
     *             The message contains a warning.
     *             </summary>
     * 
     */
    @XmlEnumValue("Warning")
    WARNING("Warning"),

    /**
     * <summary>
     *             The message contains an error description.
     *             </summary>
     * 
     */
    @XmlEnumValue("Error")
    ERROR("Error");
    private final String value;

    MessageLevel(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static MessageLevel fromValue(String v) {
        for (MessageLevel c: MessageLevel.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
