﻿using System;
using System.Windows.Forms;

using HIPS.Client.Proxy;
using HIPS.CommonSchemas;
using HIPS.CommonSchemas.PatientIdentifier;
using HIPS.ConsentSchemas;

namespace HIPS.DemoHarness
{
    public partial class DemoHarnessForm
    {
        ConsentProxy GetConsentServiceClient()
        {
            string endpointConfigurationName = environmentComboBox.Text + "_ConsentService";
            ConsentProxy client = new ConsentProxy(endpointConfigurationName);
            return client;
        }

        private void ConsentPatientComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            ClearResults();
            ConsentHospitalCodeTextBox.Text = SinglePatientParticipationHospitalCodeTextBox.Text = GetSelectedPatientHospitalCode();
            ConsentHospitalCodeSystemTextBox.Text = SinglePatientParticipationHospitalCodeSystemTextBox.Text = GetHospitalCodeSystem();
            ConsentMrnTextBox.Text = SinglePatientParticipationMrnTextBox.Text = GetSelectedPatientMrn();
            this.episodes = null;
            ConsentEpisodeComboBox.Text = "";
            ConsentEpisodeComboBox.DataSource = Episodes;
            ConsentEpisodeComboBox.DisplayMember = "AdmissionDate";
            ConsentEpisodeComboBox.ValueMember = "AdmissionDate";
            RecordConsentButton.Enabled = Episodes.Count > 0;
            SinglePatientParticipationButton.Enabled = Episodes.Count > 0;
        }

        private void ConsentEpisodeComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            ClearResults();
            string admissionDate = string.Format("{0:dd/MM/yyyy HH:mm:ss}", SelectedEpisode.AdmissionDate);
            ConsentAdmissionDateTextBox.Text = admissionDate;
            UploadHospitalCodeTextBox.Text = GetSelectedPatientHospitalCode();
            UploadMrnTextBox.Text = GetSelectedPatientMrn();
        }

        private void RecentParticipationDatePicker_ValueChanged(object sender, EventArgs e)
        {
            RecentHospitalCodeSystemTextBox.Text = GetHospitalCodeSystem();
            RecentSinceDateTextBox.Text = string.Format("{0:dd/MM/yyyy HH:mm:ss}", RecentParticipationDatePicker.Value);
        }

        private void RecordConsentButton_Click(object sender, EventArgs e)
        {
            ConsentServiceMessagesTextBox.Visible = false;
            ConsentServiceMessagesTextBox.Text = "";

            this.Cursor = Cursors.WaitCursor;
            var client = GetConsentServiceClient();
            try
            {
                string hospitalCode = GetSelectedPatientHospitalCode();
                string codingSystem = GetHospitalCodeSystem();
                string mrn = GetSelectedPatientMrn();
                bool consent = WithdrawConsentRadioButton.Checked;
                UserDetails user = GetUser();
                DateTime admissionDate = SelectedEpisode.AdmissionDate;

                HipsResponse response = client.RecordConsent(consent, new Mrn(mrn, hospitalCode, codingSystem), admissionDate, user, null);

                ConsentErrorIndicatorTextBox.Text = response.ToString();
            }
            catch (Exception ex)
            {
                ShowException(ex, ConsentServiceMessagesTextBox);
            }
            finally
            {
                try
                {
                    client.Close();
                }
                catch (Exception)
                {
                    // Ignore exception while closing client
                }
            }
            this.Cursor = Cursors.Default;
        }

        private void ListRecentParticipationButton_Click(object sender, EventArgs e)
        {
            ConsentServiceMessagesTextBox.Visible = false;
            ConsentServiceMessagesTextBox.Text = "";

            this.Cursor = Cursors.WaitCursor;
            var client = GetConsentServiceClient();
            try
            {
                string codingSystem = GetHospitalCodeSystem();
                UserDetails user = GetUser();
                DateTime since = RecentParticipationDatePicker.Value;

                PatientParticipationResponse response = client.GetRecentPatientParticipationStatus(since, codingSystem, user);

                RecentParticipationErrorIndicatorTextBox.Text = response.Response.ToString();
                PatientParticipationGridView.DataSource = response.PatientParticipationList;
            }
            catch (Exception ex)
            {
                ShowException(ex, ConsentServiceMessagesTextBox);
            }
            finally
            {
                try
                {
                    client.Close();
                }
                catch (Exception)
                {
                    // Ignore exception while closing client
                }
            }
            this.Cursor = Cursors.Default;
        }

        private void SinglePatientParticipationButton_Click(object sender, EventArgs e)
        {
            ConsentServiceMessagesTextBox.Visible = false;
            ConsentServiceMessagesTextBox.Text = "";

            this.Cursor = Cursors.WaitCursor;
            var client = GetConsentServiceClient();
            try
            {
                string hospitalCode = GetSelectedPatientHospitalCode();
                string codingSystem = GetHospitalCodeSystem();
                string mrn = GetSelectedPatientMrn();
                UserDetails user = GetUser();

                PatientParticipationResponse response = client.GetPatientParticipationStatus(new Mrn(mrn, hospitalCode, codingSystem), user);

                SinglePatientParticipationErrorIndicatorTextBox.Text = response.Response.ToString();
                PatientParticipationGridView.DataSource = response.PatientParticipationList;
            }
            catch (Exception ex)
            {
                ShowException(ex, ConsentServiceMessagesTextBox);
            }
            finally
            {
                try
                {
                    client.Close();
                }
                catch (Exception)
                {
                    // Ignore exception while closing client
                }
            }
            this.Cursor = Cursors.Default;
        }

        private void GrantConsentRadioButton_CheckedChanged(object sender, EventArgs e)
        {
            ClearResults();
            ConsentConsentTextBox.Text = "false";
            RecordConsentButton.Enabled = true;
            RecordPcehrDisclosureButton.Enabled = false;
            RecordConsentParametersGroupBox.Text = "Required Data for Record Consent Web Service Call";
            ConsentAdmissionDateLabel.Visible = true;
            ConsentAdmissionDateTextBox.Visible = true;
            ConsentLabel.Text = "Consent Withdrawn:";
        }

        private void WithdrawConsentRadioButton_CheckedChanged(object sender, EventArgs e)
        {
            ClearResults();
            ConsentConsentTextBox.Text = "true";
            RecordConsentButton.Enabled = true;
            RecordPcehrDisclosureButton.Enabled = false;
            RecordConsentParametersGroupBox.Text = "Required Data for Record Consent Web Service Call";
            ConsentAdmissionDateLabel.Visible = true;
            ConsentAdmissionDateTextBox.Visible = true;
            ConsentLabel.Text = "Consent Withdrawn:";
        }

        private void RecordPcehrDisclosureButton_Click_1(object sender, EventArgs e)
        {
            ConsentServiceMessagesTextBox.Visible = false;
            ConsentServiceMessagesTextBox.Text = "";

            this.Cursor = Cursors.WaitCursor;
            var client = GetConsentServiceClient();
            try
            {
                string hospitalCode = GetSelectedPatientHospitalCode();
                string codingSystem = GetHospitalCodeSystem();
                string mrn = GetSelectedPatientMrn();
                bool disclosed = DisclosePcehrRadioButton.Checked;
                UserDetails user = GetUser();

                HipsResponse response = client.RecordDisclosure(disclosed, new Mrn(mrn, hospitalCode, codingSystem), user, null);

                ConsentErrorIndicatorTextBox.Text = response.ToString();
            }
            catch (Exception ex)
            {
                ShowException(ex, ConsentServiceMessagesTextBox);
            }
            finally
            {
                try
                {
                    client.Close();
                }
                catch (Exception)
                {
                    // Ignore exception while closing client
                }
            }
            this.Cursor = Cursors.Default;
        }

        private void DisclosePcehrRadioButton_CheckedChanged(object sender, EventArgs e)
        {
            ClearResults();
            ConsentConsentTextBox.Text = "true";
            RecordConsentButton.Enabled = false;
            RecordPcehrDisclosureButton.Enabled = true;
            RecordConsentParametersGroupBox.Text = "Required Data for Record Disclosure Web Service Call";
            ConsentAdmissionDateLabel.Visible = false;
            ConsentAdmissionDateTextBox.Visible = false;
            ConsentLabel.Text = "PCEHR Disclosed:";
        }

        private void UndoDisclosureRadioButton_CheckedChanged(object sender, EventArgs e)
        {
            ClearResults();
            ConsentConsentTextBox.Text = "false";
            RecordConsentButton.Enabled = false;
            RecordPcehrDisclosureButton.Enabled = true;
            RecordConsentParametersGroupBox.Text = "Required Data for Record Disclosure Web Service Call";
            ConsentAdmissionDateLabel.Visible = false;
            ConsentAdmissionDateTextBox.Visible = false;
            ConsentLabel.Text = "PCEHR Disclosed:";
        }

    }
}
