﻿using System;
using System.Windows.Forms;

using HIPS.CommonSchemas;
using HIPS.CommonSchemas.PatientIdentifier;

namespace HIPS.DemoHarness
{
    public partial class DemoHarnessForm
    {
        #region Fields

        private DateTime submittedTime;

        private Attachment uploadRootDocument, CreateDocDocument;
        //        private List<Attachment> attachments = new List<Attachment>();

        #endregion

        #region Methods

        private void UploadSelectDocumentButton_Click(object sender, EventArgs e)
        {
            OpenFileDialog dialog = new OpenFileDialog();
            dialog.Filter = "CDA Document (*.xml)|*.xml";
            DialogResult result = dialog.ShowDialog(this);
            if (result == DialogResult.OK)
            {
                try
                {
                    uploadRootDocument = new Attachment();
                    uploadRootDocument.FilePath = dialog.FileName;
                    UploadCdaDocumentTextBox.Text = string.Format("{0} ({1} bytes)", uploadRootDocument.FileName, uploadRootDocument.FileSize);
                    UploadOrSupersedeButton.Enabled = true;
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.Message);
                }
            }
        }

        private void UploadAddAttachmentButton_Click(object sender, EventArgs e)
        {
            OpenFileDialog dialog = new OpenFileDialog();
            dialog.Filter = "PCEHR Supported Attachment|*.gif;*.jpg;*.jpeg;*.png;*.tif;*.tiff;*.pdf|Graphics Interchange Format|*.gif|Joint Photographic Experts Group|*.jpg;*.jpeg|Portable Network Graphics|*.png|Tagged Image File Format|*.tif;*.tiff|Portable Document Format|*.pdf";
            DialogResult result = dialog.ShowDialog(this);
            if (result == DialogResult.OK)
            {
                foreach (string path in dialog.FileNames)
                {
                    Attachment attachment = new Attachment() { FilePath = path };
                    attachmentBindingSource.Add(attachment);
                }
            }
        }

        private void UploadOrSupersedeButton_Click(object sender, EventArgs e)
        {
            submittedTime = DateTime.Now.AddSeconds(-4);
            UploadGetAuditsButton.Enabled = true;
            int numAttachments = attachmentBindingSource.Count;
            HIPS.PcehrSchemas.Attachment[] attachments = new HIPS.PcehrSchemas.Attachment[attachmentBindingSource.Count];
            for (int i = 0; i < numAttachments; i++)
            {
                Attachment attachment = attachmentBindingSource[i] as Attachment;
                attachments[i] = new PcehrSchemas.Attachment()
                {

                    FileName = attachment.FileName,
                    Contents = attachment.Contents
                };
            }

            this.Cursor = Cursors.WaitCursor;
            UploadServiceMessagesTextBox.Visible = false;
            UploadServiceMessagesTextBox.Text = "";
            var client = GetPcehrServiceClient();
            try
            {
                byte[] cdaDocument = uploadRootDocument.Contents;
                string hospitalCode = GetSelectedPatientHospitalCode();
                string hospitalCodeSystem = GetHospitalCodeSystem();
                string mrn = GetSelectedPatientMrn();
                UserDetails user = GetUser();
                DateTime admissionDate = SelectedEpisode.AdmissionDate;

                HipsResponse response = client.UploadOrSupersedeDocument(cdaDocument, new Mrn(mrn, hospitalCode, hospitalCodeSystem), user, attachments, admissionDate, null);

                UploadReturnStatusTextBox.Text = response.ToString();

                SetAuditResults(submittedTime);
            }
            catch (Exception ex)
            {
                ShowException(ex, UploadServiceMessagesTextBox);
            }
            finally
            {
                try
                {
                    client.Close();
                }
                catch (Exception)
                {
                    // Ignore exception while closing client
                }
            }
            this.Cursor = Cursors.Default;
        }

        private void UploadPatientComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            string hospitalCode = GetSelectedPatientHospitalCode();
            string codingSystem = GetHospitalCodeSystem();
            string mrn = GetSelectedPatientMrn();
            ClearResults();
            UploadHospitalCodeTextBox.Text = GetSelectedPatientHospitalCode();
            UploadMrnTextBox.Text = GetSelectedPatientMrn();
            UploadHospitalCodeSystemTextBox.Text = GetHospitalCodeSystem();

            this.episodes = null;
            UploadEpisodeComboBox.DataSource = Episodes;
            UploadEpisodeComboBox.DisplayMember = "AdmissionDate";
            UploadEpisodeComboBox.ValueMember = "AdmissionDate";
        }

        private void UploadEpisodeComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            ClearResults();
            UploadAdmissionDateTextBox.Text = string.Format("{0:dd/MM/yyyy HH:mm:ss}", SelectedEpisode.AdmissionDate);
            UploadHospitalCodeTextBox.Text = GetSelectedPatientHospitalCode();
            UploadMrnTextBox.Text = GetSelectedPatientMrn();
        }

        private void UploadGetAuditsButton_Click(object sender, EventArgs e)
        {
            SetAuditResults(submittedTime);
        }

        private void UploadQueueGridView_CellContentClick(object sender, DataGridViewCellEventArgs e)
        {
            AnyAuditDataGridViewClick(sender, e);
        }

        private void UploadRemoveAttachmentButton_Click(object sender, EventArgs e)
        {
            if (attachmentBindingSource.Current != null)
            {
                attachmentBindingSource.RemoveCurrent();
            }
        }

        private void UploadPcehrAuditGridView_CellClick(object sender, DataGridViewCellEventArgs e)
        {
            AnyAuditDataGridViewClick(sender, e);
        }

        #endregion
    }
}
