﻿using System;

namespace HIPS.Web.Components.Common
{
    public static class EnumExtensions
    {
        public static TEnum? TryParse<TEnum>(string value, bool ignoreCase) where TEnum : struct
        {
            TEnum output;
            if (Enum.TryParse(value, out output))
            {
                return output;
            }

            return null;
        }

        public static TEnum? TryParse<TEnum>(string value) where TEnum : struct
        {
            return TryParse<TEnum>(value, false);
        }
    }
}