using System;
using System.Collections.Generic;
using System.Linq;
using System.Web.Mvc;

namespace HIPS.Web.Components.Web
{
    public static class ModelStateDictionaryExtensions
    {
        public static Dictionary<string, List<string>> ToErrorDictionary(this ModelStateDictionary modelStateDictionary)
        {
            Dictionary<string, List<string>> modelStateErrors = new Dictionary<string, List<string>>();

            foreach (KeyValuePair<string, ModelState> error in modelStateDictionary.Where(m => m.Value.Errors.Count > 0))
            {
                List<string> errors = new List<string>();

                // Add error messages
                errors.AddRange(error.Value.Errors.Select(e => e.ErrorMessage));

                // Add exception errors (error messages will be blank in this case)
                errors.AddRange(error.Value.Errors.Where(e => e.Exception != null).Select(e => e.Exception.Message));

                // Ensure no blank errors
                if (errors.Count == 1)
                {
                    // Don't want to remove last error if blank (as that would bypass validation).
                    // Instead replace with a default error
                    errors[0] = string.IsNullOrWhiteSpace(errors[0]) ? "An unspecified error occurred." : errors[0];
                }
                else
                {
                    // Remove all blank errors (there will still be at least one error)
                    errors.RemoveAll(string.IsNullOrWhiteSpace);
                }

                // Append to return value
                modelStateErrors.Add(error.Key, errors);
            }

            return modelStateErrors;
        }
    }
}