﻿using AutoMapper;

using CommonSchema = HIPS.Web.Model;
using ServiceSchema = HIPS.ServiceContracts.Common.DTO;

namespace HIPS.Web.Data.Hips.Mapping.Profiles
{
    /// <summary>
    /// AutoMapper mapping profile for the CdaDocument entity.
    /// </summary>
    internal class DocumentProfile : Profile
    {
        public override string ProfileName
        {
            get { return this.GetType().Name; }
        }

        protected override void Configure()
        {
            // Service --> Common
            this.CreateMap<ServiceSchema.CdaDocumentDetails, CommonSchema.Cda.CdaDocumentDetails>();
            this.CreateMap<ServiceSchema.CdaAttachment, CommonSchema.Cda.CdaAttachment>();
            this.CreateMap<ServiceSchema.CdaDocument, CommonSchema.Cda.CdaDocument>();

            // Common --> Service
            this.CreateMap<CommonSchema.Cda.CdaAttachment, ServiceSchema.CdaAttachment>();
            this.CreateMap<CommonSchema.Cda.CdaHeaderMetadata, ServiceSchema.CdaHeaderMetadata>();
            this.CreateMap<CommonSchema.ParticipatingIndividual.ParticipatingProvider, ServiceSchema.ParticipatingIndividual.ParticipatingProvider>();

            this.CreateMap<CommonSchema.Cda.CdaAttachment, HIPS.PcehrSchemas.Attachment>()
                .ForMember(dest => dest.Contents, opt => opt.MapFrom(src => src.Content))
                .ForMember(dest => dest.FileName, opt => opt.MapFrom(src => src.FileName));
        }
    }
}