﻿using AutoMapper;

using CommonSchema = HIPS.Web.Model.Subscription;
using ServiceSchema = HIPS.P2P.Service.Contract.Common.DTO;

namespace HIPS.Web.Data.P2P.Mapping.Profiles
{
    /// <summary>
    /// AutoMapper mapping profile for messaging entities.
    /// </summary>
    public class SubscriptionProfile : Profile
    {

        #region Properties
        /// <summary>
        /// Returns the name of the mapping profile.
        /// </summary>        
        public override string ProfileName
        {
            get { return this.GetType().Name; }
        }

        #endregion

        #region Methods

        /// <summary>
        /// Configures the maps available as part of this mapping profile.
        /// </summary>
        protected override void Configure()
        {
            /*
            Common --> Service
            */

            this.CreateMap<CommonSchema.AreaOfInterest, ServiceSchema.AreaOfInterest>();

            this.CreateMap<CommonSchema.GeographicalArea, ServiceSchema.GeographicalArea>();

            this.CreateMap<CommonSchema.IndividualOccupation, ServiceSchema.IndividualOccupation>();

            this.CreateMap<CommonSchema.LocationClassification, ServiceSchema.LocationClassification>();

            this.CreateMap<CommonSchema.ProviderIdentifierSearch, ServiceSchema.Search.ProviderIdentifierSearch>();

            /*
            Service --> Common
            */

            this.CreateMap<ServiceSchema.AreaOfInterest, CommonSchema.AreaOfInterest>();

            this.CreateMap<ServiceSchema.ReferenceItem, CommonSchema.ReferenceItem>();

            this.CreateMap<ServiceSchema.GeographicalArea, CommonSchema.GeographicalArea>();

            this.CreateMap<ServiceSchema.IndividualOccupation, CommonSchema.IndividualOccupation>();

            this.CreateMap<ServiceSchema.LocationClassification, CommonSchema.LocationClassification>();

            this.CreateMap<ServiceSchema.SearchResult, CommonSchema.SearchResult>();

            this.CreateMap<ServiceSchema.ProviderIndividual, CommonSchema.ProviderIndividual>()
                .ForMember(dest => dest.Name, opt => opt.MapFrom(src => src.Name));

            this.CreateMap<ServiceSchema.IndividualName, HIPS.Web.Model.Messaging.IndividualName>()
                .ForMember(dest => dest.GivenNames, opt => opt.MapFrom(src => src.GivenName));

            this.CreateMap<ServiceSchema.ProviderOrganisation, CommonSchema.ProviderOrganisation>();
            this.CreateMap<ServiceSchema.ProviderLocation, CommonSchema.ProviderLocation>();
            this.CreateMap<ServiceSchema.ProviderLink, CommonSchema.ProviderLink>();
            this.CreateMap<ServiceSchema.InteractionRecord, CommonSchema.InteractionRecord>();
            this.CreateMap<ServiceSchema.DocumentChannelPreference, CommonSchema.DocumentChannelPreference>();
            this.CreateMap<ServiceSchema.ElectronicContact, CommonSchema.ElectronicContact>();
            this.CreateMap<ServiceSchema.Sex, HIPS.Web.Model.AssistedRegistration.Sex>();
            this.CreateMap<ServiceSchema.OrganisationName, CommonSchema.OrganisationName>();
            this.CreateMap<ServiceSchema.ProviderLocationIdentifier, CommonSchema.ProviderLocationIdentifier>();
            this.CreateMap<ServiceSchema.Address, CommonSchema.Address>();
            this.CreateMap<ServiceSchema.ProviderLinkIdentifier, CommonSchema.ProviderLinkIdentifier>();

            this.CreateMap<ServiceSchema.Search.ProviderIdentifierSearch, CommonSchema.ProviderIdentifierSearch>();
        }

        #endregion
    }
}
