using System;
using System.Collections.Generic;
using System.Linq;

using HIPS.Web.Model.AssistedRegistration;
using HIPS.Web.Model.Common;
using HIPS.Web.Model.Hpii;
using HIPS.Web.Model.Subscription;
using HIPS.Web.ModelInterface.AssistedRegistration;
using HIPS.Web.ModelInterface.Common;
using HIPS.Web.ModelInterface.DischargeSummary;
using HIPS.Web.ModelInterface.HpiiSearch;
using HIPS.Web.ModelInterface.Subscription;

namespace HIPS.Web.Data.WebsiteDb
{
    public class WebsiteDbRepository : IAssistedRegistrationReferenceRepository, IDischargeSummaryReferenceRepository, ISettingsRepository, ISubscriptionReferenceRepository, IHpiiSearchReferenceRepository
    {
        private WebsiteDbContext Database { get; set; }

        public WebsiteDbRepository()
        {
            Database = new WebsiteDbContext();
        }

        #region Assisted Registration Entities

        public List<IdentityVerificationMethod> GetIdentityVerificationMethods()
        {
            return Database.IdentityVerificationMethods.Where(i => i.IsEnabled).OrderBy(i => i.DisplayOrder).ToList();
        }

        public List<IndigenousStatus> GetIndigenousStatuses()
        {
            return Database.IndigenousStatuses.OrderBy(i => i.DisplayOrder).ToList();
        }

        public List<IvcDeliveryMethod> GetIvcDeliveryMethods()
        {
            return Database.IvcDeliveryMethods.Where(i => i.IsEnabled).OrderBy(i => i.DisplayOrder).ToList();
        }

        public List<MedicareConsent> GetMedicareConsents()
        {
            // This ordering does not address parent/child nested ordering
            return Database.MedicareConsents.Where(i => i.IsEnabled).OrderBy(i => i.DisplayOrder).ToList();
        }

        public List<Sex> GetSexes()
        {
            return Database.Sexes.OrderBy(i => i.Description).ToList();
        }

        #endregion Assisted Registration Entities

        #region Subscription Maintenance Entities

        public List<ProximityRadius> GetProximityRadius()
        {
            return Database.ProximityRadiuses.ToList();
        }

        #endregion

        #region Discharge Summary Entities

        public List<ClinicalSpecialty> GetClinicalSpecialties()
        {
            return this.Database.ClinicalSpecialties.OrderBy(c => c.Description).ToList();
        }

        #endregion Discharge Summary Entities
        
        #region HpiiSearch Entities
        
        public List<Title> GetTitles()
        {
            return this.Database.Titles.OrderBy(t => t.Description).ToList();
        }

        public List<Suffix> GetSuffixes()
        {
            return this.Database.Suffixes.OrderBy(s => s.Description).ToList();
        }
        
        #endregion
        
        #region Settings Entities

        public List<Setting> GetSettings()
        {
            return Database.Settings.ToList();
        }

        #endregion Settings Entities

        public void Dispose()
        {
            if (Database != null)
            {
                Database.Dispose();
                Database = null;
            }
        }

       
    }
}