﻿using System;

namespace HIPS.Web.Model.Directory
{

    /// <summary>
    /// Payload scheme.
    /// </summary>
    public class PayloadScheme
    {

        #region Properties

        /// <summary>
        /// Gets or sets the unique identifier of the payload scheme.
        /// </summary>
        public string QualifiedIdentifier { get; set; }

        /// <summary>
        /// Gets or sets the document type associated with the payload scheme.
        /// </summary>
        public string DocumentType { get; set; }

        /// <summary>
        /// Gets or sets the payload packaging associated with the payload scheme.
        /// </summary>
        public string PayloadPackaging { get; set; }

        /// <summary>
        /// Gets or sets the name of the payload scheme.
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// Gets or sets any additional comments associated with the payload scheme.
        /// </summary>
        public string AdditionalComments { get; set; }

        /// <summary>
        /// Gets or sets an integer value representing the priority associated with the payload scheme, where higher priorities are represented by higher values.
        /// </summary>
        public int PriorityNumber { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether the payload scheme is active (available for use).
        /// </summary>
        public bool IsActive { get; set; }

        /// <summary>
        /// Gets or sets a date and time value representing the modification timestamp of the entity within its persistence store.
        /// </summary>
        public DateTime Timestamp { get; set; }

        #endregion

    }

}
