﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using HIPS.Web.Model.Directory;

namespace HIPS.Web.Model.Messaging
{
    /// <summary>
    /// Sealed Message.
    /// </summary>
    public class SealedMessage
    {
        #region Properties
        
        /// <summary>
        /// Gets or sets the unique invocation identifier of the message.
        /// </summary>
        public string InvocationIdentifier { get; set; }
        
        /// <summary>
        /// Gets or sets the sender of the message.
        /// </summary>
        public MessageAddressee Sender { get; set; }
        
        /// <summary>
        /// Gets or sets the recipient of the message.
        /// </summary>
        public MessageAddressee Receiver { get; set; }

        /// <summary>
        /// Gets or sets the timestamp of the message.
        /// </summary>
        public DateTime MessageTimestamp { get; set; }

        /// <summary>
        /// Gets or sets the payload scheme associated with the the message.
        /// </summary>
        public PayloadScheme PayloadScheme { get; set; }

        /// <summary>
        /// Gets or sets the set of transport responses sent or received for the message.
        /// </summary>
        public List<TransportResponse> TransportResponses { get; set; }

        /// <summary>
        /// Gets or sets the subject of care.
        /// </summary>
        public ConsumerIdentity SubjectOfCare { get; set; }

        #endregion
    }
}
