﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace HIPS.Web.Model.Subscription
{
    public class AddressSearch
    {
        #region Properties

        /// <summary>
        /// Gets or sets the code representing the address purpose.
        /// </summary>
        public string ContactPurposeCode { get; set; }

        /// <summary>
        /// Gets or sets the unit type.
        /// </summary>
        public string FlatType { get; set; }

        /// <summary>
        /// Gets or sets the unit number.
        /// </summary>
        public string FlatNumber { get; set; }

        /// <summary>
        /// Gets or sets the site name.
        /// </summary>
        public string AddressSiteName { get; set; }

        /// <summary>
        /// Gets or sets the level type.
        /// </summary>
        public string LevelType { get; set; }

        /// <summary>
        /// Gets or sets the level number.
        /// </summary>
        public string LevelNumber { get; set; }

        /// <summary>
        /// Gets or sets the street number.
        /// </summary>
        public string StreetNumber { get; set; }

        /// <summary>
        /// Gets or sets the lot number.
        /// </summary>
        public string LotNumber { get; set; }

        /// <summary>
        /// Gets or sets the street name.
        /// </summary>
        public string StreetName { get; set; }

        /// <summary>
        /// Gets or sets the street type.
        /// </summary>
        public string StreetType { get; set; }

        /// <summary>
        /// Gets or sets the street suffix.
        /// </summary>
        public string StreetSuffix { get; set; }

        /// <summary>
        /// Gets or sets the postal delivery type.
        /// </summary>
        public string PostalDeliveryType { get; set; }

        /// <summary>
        /// Gets or sets the postal delivery number.
        /// </summary>
        public string PostalDeliveryNumber { get; set; }

        /// <summary>
        /// Gets or sets the unstructured address line.
        /// </summary>
        public string UnstructuredAddressLine { get; set; }

        /// <summary>
        /// Gets or sets the suburb, town or locality.
        /// </summary>
        public string Suburb { get; set; }

        /// <summary>
        /// Gets or sets the state or territory.
        /// </summary>
        public string State { get; set; }

        /// <summary>
        /// Gets or sets the postcode.
        /// </summary>
        public string Postcode { get; set; }

        /// <summary>
        /// Gets or sets the geocoded latitude.
        /// </summary>
        public string Latitude { get; set; }

        /// <summary>
        /// Gets or sets the geocoded longitude.
        /// </summary>
        public string Longitude { get; set; }

        #endregion
    }
}
