﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using HIPS.Web.Model.Messaging;

namespace HIPS.Web.Model.Subscription
{
    public class ProviderOrganisation
    {
        #region Properties

        /// <summary>
        /// Gets or sets the primary identifier for this organisation.
        /// </summary>        
        public string OrganisationId { get; set; }

        /// <summary>
        /// Gets or sets the list of identifiers for the organisation, including national and local identifiers.
        /// </summary>        
        public List<ProviderOrganisationIdentifier> Identifiers { get; set; }

        /// <summary>
        /// Gets or sets the organisation legal name.
        /// </summary>
        public string LegalName { get; set; }

        /// <summary>
        /// Gets or sets the list of additional organisation names with codes describing how the organisation name is used.
        /// </summary>
        public List<OrganisationName> OrganisationNames { get; set; }

        /// <summary>
        /// Gets or sets the organisation description.
        /// </summary>
        public string OrganisationDescription { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether the individual is subscribed.
        /// </summary>
        public bool IsInSubscription { get; set; }

        #endregion
    }
}
