﻿using System;
using System.Collections.Generic;

using HIPS.Web.Components.ServiceModel;
using HIPS.Web.Model.Directory;
using HIPS.Web.Model.Identity;

namespace HIPS.Web.ModelInterface.Directory
{

    /// <summary>
    /// Supports the maintenance of directory configuration.
    /// </summary>
    public interface IDirectoryConfigurationService
    {

        #region Methods

        /// <summary>
        /// Returns a list of all configured payload schemes.
        /// </summary>
        /// <param name="userContext">User context within which the service is accessed.</param>
        /// <returns>A ServiceResponse object</returns>
        ServiceResponse<List<PayloadScheme>> ListPayloadSchemes(LocalUser userContext);

        /// <summary>
        /// Sets the activation state of a specified payload scheme in order to activate or inactivate it.
        /// </summary>
        /// <param name="qualifiedIdentifier">Unique identifier of the payload scheme.</param>
        /// <param name="isActive">Boolean value that indicates whether the payload scheme is active (available for use).</param>
        /// <param name="userContext">User context within which the service is accessed.</param>
        /// <returns>A ServiceResponse object</returns>
        ServiceResponse<object> ActivatePayloadScheme(string qualifiedIdentifier, bool isActive, LocalUser userContext);

        /// <summary>
        /// Returns a list of all delegates
        /// </summary>
        /// <param name="userContext">User context within which the service is accessed.</param>
        /// <returns>A ServiceResponse object</returns>
        ServiceResponse<List<HIPS.Web.Model.Directory.Delegate>> ListDelegates(LocalUser userContext);

        /// <summary>
        /// Sets the activation state of a specified delegate in order to activate or inactivate it.
        /// </summary>
        /// <param name="qualifiedIdentifier">The ID of the delegate to activate or deactivate.</param>
        /// /// <param name="isActive">Boolean value to activate or deactivate a delegate.</param>
        /// /// <param name="userContext">User context within which the service is accessed.</param>
        /// <returns>A ServiceResponse object</returns>
        ServiceResponse<object> ActivateDelegate(string qualifiedIdentifier, bool isActive, LocalUser userContext);

        /// <summary>
        /// Prioritises the delegate
        /// </summary>
        /// <param name="qualifiedIdentifier">The ID of the delegate to prioritise.</param>
        /// <param name="relativeToQualifiedIdentifier">The ID of the delegate where the ID pointed to by qualifiedIdentifier will be prioritised over to.</param>
        /// <param name="userContext">User context within which the service is accessed.</param>
        /// <returns>A ServiceResponse object</returns>
        ServiceResponse<object> PrioritiseDelegate(string qualifiedIdentifier, string relativeToQualifiedIdentifier, LocalUser userContext);

        /// <summary>
        /// List all intermediaries
        /// </summary>
        /// <param name="userContext">User context within which the service is accessed.</param>
        /// <returns>A ServiceResponse object</returns>
        ServiceResponse<List<Intermediary>> ListIntermediaries(LocalUser userContext);

        /// <summary>
        /// Sets the delegates intermediary
        /// </summary>
        /// <param name="qualifiedIdentifier">The ID of the delegate whose intermediary will be changed.</param>
        /// <param name="intermediaryServiceEndpointUri">The endpoint URI representing the intermediary record.</param>
        /// <param name="userContext">User context within which the service is accessed.</param>
        /// <returns>A ServiceResponse object</returns>
        ServiceResponse<object> MediateDelegate(string qualifiedIdentifier, string intermediaryServiceEndpointUri, LocalUser userContext);

        /// <summary>
        /// Returns a list of all document types.
        /// </summary>
        /// <param name="userContext">User context within which the service is accessed.</param>
        /// <returns>ServiceResponse object.</returns>
        ServiceResponse<List<DocumentType>> ListDocumentTypes(LocalUser userContext);

        #endregion
    
    }
}
