﻿using System;
using System.Collections.Generic;

using HIPS.Web.Components.ServiceModel;
using HIPS.Web.Model.Directory.Search;
using HIPS.Web.Model.Subscription;
using HIPS.Web.Model;

namespace HIPS.Web.ModelInterface.Directory
{
    /// <summary>
    /// Defines the operations to be supported by an implementation of a ProviderIndividual Directory Service.
    /// </summary>
    public interface IProviderIndividualDirectoryService
    {

        #region Methods

        /// <summary>
        /// Searches the LHSD for a list of provider individuals and their linked organisations.
        /// </summary>
        /// <param name="request">Request message.</param>
        /// <returns>Response message.</returns>
        ServiceResponse<SearchResult> Search(ProviderIndividualSearch individual, ProviderOrganisationSearch organisation, 
            ProviderLocationSearch location, ProviderLinkSearch link, List<Entity> entities, 
            int? providerIndividualLimit, int? providerIndividualSkip, Model.Identity.LocalUser userContext);

        #endregion

    }
}
