﻿using System.Collections.Generic;

using HIPS.Web.Components.Cache;
using HIPS.Web.Model.Subscription;

namespace HIPS.Web.ModelInterface.Subscription
{
    public class CachedSubscriptionReferenceRepository : ISubscriptionReferenceRepository
    {
          #region Fields

        /// <summary>
        /// Cache key format.
        /// </summary>
        private readonly string cacheKeyFormat;

        /// <summary>
        /// Cache provider.
        /// </summary>
        private readonly ICacheProvider cacheProvider;

        /// <summary>
        /// Reference repository.
        /// </summary>
        private ISubscriptionReferenceRepository referenceRepository;

        #endregion Fields

        #region Constructors

        /// <summary>
        /// Initialises a new instance of the <see cref="CachedSubscriptionReferenceRepository"/> class.
        /// </summary>
        /// <param name="referenceRepository">Reference repository.</param>
        /// <param name="cacheProvider">Cache provider.</param>
        /// <param name="cacheKeyPrefix">Cache key format.</param>
        public CachedSubscriptionReferenceRepository(
            ISubscriptionReferenceRepository referenceRepository,
            ICacheProvider cacheProvider,
            string cacheKeyPrefix = "")
        {
            this.referenceRepository = referenceRepository;
            this.cacheProvider = cacheProvider;
            this.cacheKeyFormat = cacheKeyPrefix + ".CachedSubscriptionReferenceRepository.{0}";
        }

        #endregion Constructors

        #region Methods

        /// <summary>
        /// Gets all Proximity Radiuses.
        /// </summary>
        /// <returns>List of Clinical Specialties.</returns>
        public List<ProximityRadius> GetProximityRadius()
        {
            return this.cacheProvider.GetOrSet(string.Format(this.cacheKeyFormat, "GetProximityRadius()"), () => this.referenceRepository.GetProximityRadius());
        }

        /// <summary>
        /// Dispose.
        /// </summary>
        public void Dispose()
        {
            if (this.referenceRepository != null)
            {
                this.referenceRepository.Dispose();
                this.referenceRepository = null;
            }
        }

        #endregion Methods
    }
}
