﻿using Microsoft.AspNet.Identity;
using Microsoft.Owin;
using Microsoft.Owin.Security.Cookies;
using Owin;
using System;

namespace HIPS.Web.UI
{
    public partial class Startup
    {
        // For more information on configuring authentication, please visit http://go.microsoft.com/fwlink/?LinkId=301864
        public void ConfigureAuth(IAppBuilder app)
        {
            // Enable the application to use a cookie to store information for the signed in user
            app.UseCookieAuthentication(new CookieAuthenticationOptions
            {
                AuthenticationType = DefaultAuthenticationTypes.ApplicationCookie,
                CookieHttpOnly = true,
                CookieSecure = (CookieSecureOption)Enum.Parse(typeof(CookieSecureOption), System.Configuration.ConfigurationManager.AppSettings["ApplicationCookie.Secure"]),                
                LoginPath = new PathString("/Account/Login"),
                LogoutPath = new PathString("/Common/Logoff"),
                ExpireTimeSpan = System.TimeSpan.FromMinutes(Convert.ToInt32(System.Configuration.ConfigurationManager.AppSettings["ApplicationCookie.Timeout"].ToString())),
                SlidingExpiration = true
            });

            // Uncomment the following lines to enable logging in with third party login providers

            // Use a cookie to temporarily store information about a user logging in with a third party login provider
            //app.UseExternalSignInCookie(DefaultAuthenticationTypes.ExternalCookie);
            
            //app.UseMicrosoftAccountAuthentication(
            //    clientId: "",
            //    clientSecret: "");

            //app.UseTwitterAuthentication(
            //   consumerKey: "",
            //   consumerSecret: "");

            //app.UseFacebookAuthentication(
            //   appId: "",
            //   appSecret: "");

            //app.UseGoogleAuthentication();
        }
    }
}