﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Web;

namespace HIPS.Web.UI.Areas.Directory.ViewModels
{
    /// <summary>
    /// Activate delegate view model.
    /// </summary>
    public class ActivateDelegateViewModel : DirectoryViewModelBase
    {
        #region Properties

        /// <summary>
        /// Gets or sets the qualified identifier of the delegate to be activated or deactivated.
        /// </summary>
        [Required]
        [Display(Name = "Qualified Identifier")]
        public string QualifiedIdentifier { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether whether to activate (true) or deactivate (false) the delegate.
        /// </summary>
        [Required]
        [Display(Name = "Is Active")]
        public bool IsActive { get; set; }

        #endregion
    }
}