﻿using System;

using HIPS.Web.UI.ViewModels.Shared;

namespace HIPS.Web.UI.Areas.Directory.ViewModels
{
    /// <summary>
    /// Abstract base class for directory view models.
    /// </summary>
    public abstract class DirectoryViewModelBase
    {
        #region Constructors

        /// <summary>
        /// Initialises a new instance of the <see cref="DirectoryViewModelBase"/> class.
        /// </summary>
        public DirectoryViewModelBase()
        {
            this.Messages = new ViewMessageList();
        }

        #endregion

        #region Properties

        /// <summary>
        /// Gets or sets the list of messages associated with the view model.
        /// </summary>
        public ViewMessageList Messages { get; set; }

        #endregion
    }
}