﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;

using HIPS.Web.Model.Directory;
using HIPS.Web.UI.ViewModels.Shared;

namespace HIPS.Web.UI.Areas.Directory.ViewModels
{
    /// <summary>
    /// Payload schemes list view model.
    /// </summary>
    public class ListPayloadSchemesViewModel : DirectoryViewModelBase
    {
        #region Constructors

        /// <summary>
        /// Initialises a new instance of the <see cref="ListPayloadSchemesViewModel"/> class.
        /// </summary>
        public ListPayloadSchemesViewModel()
            : base()
        {
            this.PayloadSchemes = new List<PayloadScheme>();
        }

        #endregion
        
        #region Properties

        /// <summary>
        /// Gets or sets the list of payload schemes associated with the view model.
        /// </summary>
        public List<PayloadScheme> PayloadSchemes { get; set; }

        #endregion
    }
}