﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace HIPS.Web.UI.Areas.Messaging.ViewModels
{
    /// <summary>
    /// View model for filtering outbound sealed messages.
    /// </summary>
    public class DeliveryFilterViewModel : MessagingBaseViewModel
    {
        /// <summary>
        /// Gets or sets the Receiver.
        /// </summary>
        public string Receiver { get; set; }
        
        /// <summary>
        /// Gets or sets the Sender HPI-O.
        /// </summary>
        [Display(Name = "Sender")]
        public string SenderHpio { get; set; }
        
        /// <summary>
        /// Gets or sets the list of senders available for selection.
        /// </summary>
        public IEnumerable<SelectListItem> Senders { get; set; }
    }
}