﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace HIPS.Web.UI.Areas.Messaging.ViewModels
{
    /// <summary>
    /// View model for filtering inbound sealed messages.
    /// </summary>
    public class ReceiptFilterViewModel : MessagingBaseViewModel
    {
        /// <summary>
        /// Gets or sets the Sender.
        /// </summary>
        public string Sender { get; set; }

        /// <summary>
        /// Gets or sets the Receiver HPI-O.
        /// </summary>
        [Display(Name = "Receiver")]
        public string ReceiverHpio { get; set; }

        /// <summary>
        /// Gets or sets the list of receivers available for selection.
        /// </summary>
        public IEnumerable<SelectListItem> Receivers { get; set; }
    }
}