﻿using System;
using HIPS.HpiiSchemas;
using HIPS.Web.Components.Common;
using HIPS.Web.UI.ViewModels.HpiiSearch;
using nehta.mcaR50.ProviderSearchForProviderIndividual;

namespace HIPS.Web.UI.Conversion.HpiiSearch
{
    public static class SearchByIdViewModelExtensions
    {
        /// <summary>
        /// Create a new HPI-I identifier query from the view model.
        /// </summary>
        /// <param name="viewModel">The model to get the data from.</param>
        /// <returns>The created HPI-I identifier query.</returns>
        public static HpiiIdentifierQuery ToIdentifierQuery(this SearchByIdViewModel viewModel)
        {
            return new HpiiIdentifierQuery
            {
                HpioNumber = viewModel.Hpio,
                FamilyName = viewModel.FamilyName,
                GivenName = !string.IsNullOrEmpty(viewModel.GivenNames) ? viewModel.GivenNames.Split(' ') : new string[0],
                DateofBirth = viewModel.DateOfBirth,
                Sex = EnumExtensions.TryParse<SexType>(viewModel.SexCode),
                HpiiNumber = viewModel.Hpii,
                RegistrationId = viewModel.RegistrationId,
                PostCode = viewModel.Postcode,
                State = EnumExtensions.TryParse<StateType>(viewModel.StateCode)
            };
        }
    }
}