﻿using Elmah;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace HIPS.Web.UI.Helpers
{
    public class ElmahExtensions
    {

        public static void ApplySensitiveDataFilter(ExceptionFilterEventArgs e, HttpContext ctx)
        {
            var sensitiveFormData = ctx.Request.Form.AllKeys
                    .Where(key => key.Equals("password", StringComparison.OrdinalIgnoreCase)).ToList();
            if (sensitiveFormData.Count == 0)
            {
                return;
            }
            var error = new Error(e.Exception, ctx);
            sensitiveFormData.ForEach(k => error.Form.Set(k, "*****"));
            Elmah.ErrorLog.GetDefault(null).Log(error);
            e.Dismiss();
        }
    }
}