﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace HIPS.Web.UI.ViewModels.HpiiSearch
{
    /// <summary>
    /// View model for deactivating a Provider.
    /// </summary>
    public class DeactivateProviderViewModel
    {
        #region Constructors

        /// <summary>
        /// Initialises a new instance of the <see cref="DeactivateProviderViewModel" /> class.
        /// </summary>
        public DeactivateProviderViewModel()
        {
            this.DeactivatedDate = DateTime.Now;
        }

        #endregion
        
        #region Properties

        /// <summary>
        /// Gets or sets Local Provider Code.
        /// </summary>
        public string LocalProviderCode { get; set; }
        
        /// <summary>
        /// Gets or sets Deactivation Date.
        /// </summary>
        [Display(Name = "Deactivation Date")]
        public DateTime DeactivatedDate { get; set; }
        
        #endregion
    }
}
