﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Web.Mvc;

using HIPS.Web.Components.Validation;

namespace HIPS.Web.UI.ViewModels.HpiiSearch
{
    /// <summary>
    /// View model for editing an existing Provider.
    /// </summary>
    public class EditProviderViewModel : LocalProviderViewModelBase
    {
        /// <summary>
        /// Gets or sets Local Provider Code.
        /// </summary>
        public string LocalProviderCode { get; set; }
        
        /// <summary>
        /// Gets or sets Selected Title Id.
        /// </summary>
        [Display(Name = "Title")]
        public string SelectedTitleId { get; set; }

        /// <summary>
        /// Gets or set Titles.
        /// </summary>
        public IEnumerable<SelectListItem> Titles { get; set; }
        
        /// <summary>
        /// Gets or sets Selected Suffix Id.
        /// </summary>
        [Display(Name = "Suffix")]
        public string SelectedSuffixId { get; set; }

        /// <summary>
        /// Gets or sets Suffixes.
        /// </summary>
        public IEnumerable<SelectListItem> Suffixes { get; set; }
        
        /// <summary>
        /// Gets or sets Family Name.
        /// </summary>
        [Required]
        [Display(Name = "Family Name")]
        public string FamilyName { get; set; }

        /// <summary>
        /// Gets or sets Given Name.
        /// </summary>
        [Display(Name = "Given Name")]
        public string GivenName { get; set; }

        /// <summary>
        /// Gets or sets Hpii.
        /// </summary>
        [StringLength(16, MinimumLength = 16, ErrorMessage = "HPI-I must be 16 characters long.")]
        [Display(Name = "HPI-I")]
        [LuhnCheckDigitValidator]
        public string Hpii { get; set; }

        /// <summary>
        /// Gets or sets Local Provider Identifier.
        /// </summary>
        [Required]
        [Display(Name = "Local Identifier")]
        public string LocalProviderIdentifier { get; set; }
    }
}
