﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using HIPS.Web.UI.ViewModels.Shared;

namespace HIPS.Web.UI.ViewModels.HpiiSearch
{
    /// <summary>
    /// View model containing list of local providers.
    /// </summary>
    public class ListLocalProvidersViewModel : LocalProviderViewModelBase
    {
        #region Constructors

        /// <summary>
        /// Initialises a new instance of the <see cref="ListLocalProvidersViewModel" /> class.
        /// </summary>
        public ListLocalProvidersViewModel()
        {
            this.LocalProviders = Enumerable.Empty<LocalProviderViewModel>().ToList();
        }

        #endregion
        
        #region Properties

        /// <summary>
        /// Gets or sets a list of Local Providers.
        /// </summary>
        public List<LocalProviderViewModel> LocalProviders { get; set; }

        #endregion
    }
}
