using System;
using System.Collections.Generic;
using System.Linq;
using HIPS.Web.Model.AssistedRegistration;

namespace HIPS.Web.BusinessLogic.AssistedRegistration
{
    /// <summary>
    /// Extension validation for IvcDeliveryMethodDecision
    /// </summary>
    public static class IvcDeliveryMethodDecisionValidation
    {
        /// <summary>
        /// Validates the IvcDeliveryMethodDecision, ensuring any required destination information was provided.
        /// </summary>
        /// <param name="ivcDeliveryMethodDecision"></param>
        /// <returns>An enumeration of error strings, otherwise an empty enumeration.</returns>
        public static IEnumerable<string> Validate(this IvcDeliveryMethodDecision ivcDeliveryMethodDecision)
        {
            // No validation required if doesn't require a destination
            if (!ivcDeliveryMethodDecision.IvcDeliveryMethod.RequiresDestination)
            {
                return Enumerable.Empty<string>();
            }

            // TODO: Regex on IvcDeliveryMethod
            List<string> errors = new List<string>();

            // Requires a contact destination to be provided
            if (String.IsNullOrWhiteSpace(ivcDeliveryMethodDecision.ContactDestination))
            {
                errors.Add("The IVC Delivery Method selected requires contact details.");
                return errors;
            }

            // If confirmation required, verify the confirmation
            if (ivcDeliveryMethodDecision.IvcDeliveryMethod.RequiresDestinationConfirm)
            {
                if (String.IsNullOrWhiteSpace(ivcDeliveryMethodDecision.ContactDestinationConfirmation))
                {
                    errors.Add("The IVC Delivery Method requires contact details to be confirmed.");
                }
                else if (ivcDeliveryMethodDecision.ContactDestination != ivcDeliveryMethodDecision.ContactDestinationConfirmation)
                {
                    errors.Add("The IVC Delivery Method contact details confirmation does not match.");
                }
            }

            return errors;
        }
    }
}