﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using AutoMapper;
using CommonSchema = HIPS.Web.Model.Hpii;
using ServiceSchema = HIPS.ServiceContracts.Hpii.DTO;

namespace HIPS.Web.Data.Hips.Mapping.Profiles
{
    /// <summary>
    /// AutoMapper mapping profile for the LocalProvider entity.
    /// </summary>
    internal class LocalProviderProfile : Profile
    {
        /// <summary>
        /// Returns the name of the mapping profile.
        /// </summary>
        public override string ProfileName
        {
            get { return this.GetType().Name; }
        }

        /// <summary>
        /// Configures the maps available as part of this mapping profile.
        /// </summary>
        protected override void Configure()
        {
            // Service --> Common
            this.CreateMap<ServiceSchema.LocalProvider, CommonSchema.LocalProvider>()                
                .ForMember(dest => dest.FamilyName, opt => opt.MapFrom(src => src.FamilyName))
                .ForMember(dest => dest.GivenNames, opt => opt.MapFrom(src => src.GivenNames))
                .ForMember(dest => dest.Title, opt => opt.MapFrom(src => src.Title))
                .ForMember(dest => dest.Suffix, opt => opt.MapFrom(src => src.Suffix))
                .ForMember(dest => dest.Hpii, opt => opt.MapFrom(src => src.Hpii))
                .ForMember(dest => dest.Active, opt => opt.MapFrom(src => src.Active))
                .ForMember(dest => dest.HpiiStatus, opt => opt.MapFrom(src => src.HpiiStatus))
                .ForMember(dest => dest.LocalProviderCode, opt => opt.MapFrom(src => src.LocalProviderCode))
                .ForMember(dest => dest.LocalProviderIdentifiers, opt => opt.MapFrom(src => src.LocalProviderIdentifiers));
                
            this.CreateMap<ServiceSchema.LocalProviderIdentifier, CommonSchema.LocalProviderIdentifier>()
                .ForMember(dest => dest.CisProviderIdentifier, opt => opt.MapFrom(src => src.CisProviderIdentifier))
                .ForMember(dest => dest.HospitalCode, opt => opt.MapFrom(src => src.HospitalCode))
                .ForMember(dest => dest.HospitalCodeSystem, opt => opt.MapFrom(src => src.HospitalCodeSystem))
                .ForMember(dest => dest.LocalProviderCode, opt => opt.MapFrom(src => src.LocalProviderCode))
                .ForMember(dest => dest.PasProviderIdentifier, opt => opt.MapFrom(src => src.PasProviderIdentifier));

            this.CreateMap<CommonSchema.LocalProviderIdentifier, ServiceSchema.LocalProviderIdentifier>()
                .ForMember(dest => dest.CisProviderIdentifier, opt => opt.MapFrom(src => src.CisProviderIdentifier))
                .ForMember(dest => dest.HospitalCode, opt => opt.MapFrom(src => src.HospitalCode))
                .ForMember(dest => dest.HospitalCodeSystem, opt => opt.MapFrom(src => src.HospitalCodeSystem))
                .ForMember(dest => dest.LocalProviderCode, opt => opt.MapFrom(src => src.LocalProviderCode))
                .ForMember(dest => dest.PasProviderIdentifier, opt => opt.MapFrom(src => src.PasProviderIdentifier));
        }
    }
}
