﻿using AutoMapper;

using ServiceSchema = HIPS.P2P.Service.Contract.Common.DTO;
using CommonSchema = HIPS.Web.Model.Directory;

namespace HIPS.Web.Data.P2P.Mapping.Profiles
{

    /// <summary>
    /// AutoMapper mapping profile for directory entities.
    /// </summary>
    internal class DirectoryProfile : Profile
    {

        #region Methods

        /// <summary>
        /// Configures the maps available as part of this mapping profile.
        /// </summary>
        protected override void Configure()
        {

            /*
            Service --> Common
            */

            // PayloadScheme
            this.CreateMap<ServiceSchema.PayloadScheme, CommonSchema.PayloadScheme>()
                .ForMember(dest => dest.DocumentType, opt => opt.MapFrom(src => src.DocumentType.Description))
                .ForMember(dest => dest.PayloadPackaging, opt => opt.MapFrom(src => src.PayloadPackaging.Description));

            // Delegate
            this.CreateMap<ServiceSchema.Delegate, CommonSchema.Delegate>()
                .ForMember(dest => dest.Intermediary, opt => opt.MapFrom(src => ObjectMapper.Map<CommonSchema.Intermediary>(src.Intermediary)));

            // Intermediary
            this.CreateMap<ServiceSchema.Intermediary, CommonSchema.Intermediary>();

            // DocumentType
            this.CreateMap<ServiceSchema.DocumentType, CommonSchema.DocumentType>();

            // ProviderIdentifierStatus
            this.CreateMap<ServiceSchema.ProviderIdentifierStatus, HIPS.Web.Model.Messaging.ProviderIdentifierStatus>();

            /*
           Common --> Service
           */

            // ProviderIndividualSearch
            this.CreateMap<CommonSchema.Search.ProviderIndividualSearch, ServiceSchema.Search.ProviderIndividualSearch>();

            // ProviderOrganisationSearch
            this.CreateMap<CommonSchema.Search.ProviderOrganisationSearch, ServiceSchema.Search.ProviderIndividualSearch>();

            // ProviderLocationSearch
            this.CreateMap<CommonSchema.Search.ProviderLocationSearch, ServiceSchema.Search.ProviderLocationSearch>();

            // ProviderLinkSearch
            this.CreateMap<CommonSchema.Search.ProviderLinkSearch, ServiceSchema.Search.ProviderLinkSearch>();

            // ProviderOrganisationSearch
            this.CreateMap<CommonSchema.Search.ProviderOrganisationSearch, ServiceSchema.Search.ProviderOrganisationSearch>();

            // ProviderIdentifierSearch
            this.CreateMap<HIPS.Web.Model.Subscription.ProviderIdentifierSearch, ServiceSchema.Search.ProviderIdentifierSearch>();

        }

        /// <summary>
        /// Returns the name of the mapping profile.
        /// </summary>
        public override string ProfileName
        {
            get { return this.GetType().Name; }
        }

        #endregion

    }
}
