﻿using System.Collections.Generic;
using System.ServiceModel;

using AutoMapper;

using CommonSchema = HIPS.Web.Components.ServiceModel;
using ServiceSchema = HIPS.P2P.Service.Contract.Common.DTO;

namespace HIPS.Web.Data.P2P.Mapping.Profiles
{
    /// <summary>
    /// AutoMapper mapping profile for messages.
    /// </summary>
    internal class MessageProfile : Profile
    {
        /// <summary>
        /// Returns the name of the mapping profile.
        /// </summary>
        public override string ProfileName
        {
            get { return this.GetType().Name; }
        }

        #region Methods

        /// <summary>
        /// Configures the maps available as part of this mapping profile.
        /// </summary>
        protected override void Configure()
        {
            /*
            Service --> Common
            */

            this.CreateMap<ServiceSchema.Message, CommonSchema.ResponseMessage>()
                .ForMember(dest => dest.Description, opt => opt.MapFrom(src => string.Format("{0} [Code: {1}; Origin: {2}]", src.Description, src.Code, src.Origin)))
                .ForMember(dest => dest.Level, opt => opt.MapFrom(src => this.TransformMessageLevel(src.Level)));
        }

        /// <summary>
        /// Transform between MessageLevel enumerations.
        /// </summary>
        /// <param name="src">Source MessageLevel.</param>
        /// <returns>Target MessageLevel.</returns>
        private HIPS.Web.Components.Common.MessageLevel TransformMessageLevel(HIPS.P2P.Service.Contract.Common.MessageLevel src)
        {
            switch (src)
            {
                case HIPS.P2P.Service.Contract.Common.MessageLevel.None:
                case HIPS.P2P.Service.Contract.Common.MessageLevel.Information:
                    {
                        return HIPS.Web.Components.Common.MessageLevel.Information;
                    }
                case HIPS.P2P.Service.Contract.Common.MessageLevel.Warning:
                    {
                        return HIPS.Web.Components.Common.MessageLevel.Warning;
                    }
                case HIPS.P2P.Service.Contract.Common.MessageLevel.Error:
                    {
                        return HIPS.Web.Components.Common.MessageLevel.Error;
                    }
                default:
                    {
                        return Components.Common.MessageLevel.Information;
                    }
            }
        }

        #endregion
    }
}