﻿using System;
using System.Collections.Generic;

using HIPS.P2P.Service.Contract.Common;
using HIPS.P2P.Service.Contract.Messaging.Delivery.Message;
using HIPS.Web.Components.ServiceModel;
using HIPS.Web.Data.P2P.Mapping;
using HIPS.Web.ModelInterface.Directory;
using HIPS.Web.Model.Directory.Search;

using CommonSchema = HIPS.Web.Model.Subscription;
using ServiceSchema = HIPS.P2P.Service.Contract.Common.DTO.Search;
using HIPS.P2P.Service.Contract.Directory.ProviderIndividual.Message;

namespace HIPS.Web.Data.P2P.Service
{
    /// <summary>
    /// Defines the implementation of the Subscription Maintenance.
    /// </summary>
    public class ProviderIndividualDirectoryService : ServiceBase<HIPS.P2P.Client.Proxy.ProviderIndividualDirectoryProxy>, IProviderIndividualDirectoryService
    {
        #region Constructor

        /// <summary>
        /// Initialises a new instance of the <see cref="ProviderIndividualDirectoryService"/> class.
        /// </summary>
        public ProviderIndividualDirectoryService()
        {
            this.ClientProxy = new HIPS.P2P.Client.Proxy.ProviderIndividualDirectoryProxy("ProviderIndividualEndPoint");
        }

        #endregion

        #region Methods

        /// <summary>
        /// Searches the LHSD for provider individuals matching the search query.
        /// </summary>
        /// <param name="individual">Individual criteria.</param>
        /// <param name="organisation">Organisation criteria.</param>
        /// <param name="location">Location criteria.</param>
        /// <param name="link">Link criteria.</param>
        /// <param name="entities">The list of entities that should be returned in the search results.</param>
        /// <param name="limit">Maximum number of individuals to match.</param>
        /// <param name="skip">Number of individuals to skip over.</param>
        /// <returns>Response message.</returns>
        public ServiceResponse<CommonSchema.SearchResult> Search(ProviderIndividualSearch individual, ProviderOrganisationSearch organisation, 
            ProviderLocationSearch location, ProviderLinkSearch link, List<HIPS.Web.Model.Entity> entities, int? providerIndividualLimit, 
            int? providerIndividualSkip, Model.Identity.LocalUser userContext)
        {
            ResponseMessageList messages = new ResponseMessageList();
            bool isSuccessful = false;

            try
            {
                // Generate Request
                var request = new SearchRequest()
                {
                    Individual = ObjectMapper.Map<ServiceSchema.ProviderIndividualSearch>(individual),
                    Organisation = ObjectMapper.Map<ServiceSchema.ProviderOrganisationSearch>(organisation),
                    Location = ObjectMapper.Map<ServiceSchema.ProviderLocationSearch>(location),
                    Link = ObjectMapper.Map<ServiceSchema.ProviderLinkSearch>(link),
                    Entities = ObjectMapper.Map <List<HIPS.P2P.Service.Contract.Common.Entity>>(entities), 
                    ProviderIndividualLimit = providerIndividualLimit,
                    ProviderIndividualSkip = providerIndividualSkip,
                    User = ObjectMapper.Map<HIPS.P2P.Service.Contract.Common.DTO.UserIdentity.LocalUser>(userContext)
                };
                // HIPS.P2P.Service.Contract.Common

                var result = this.ClientProxy.Search(request);
                // HIPS Status should be OK
                isSuccessful = result.Status == ResponseStatus.OK;

                // Add HIPS messages
                messages.AddRange(ObjectMapper.Map<List<ResponseMessage>>(result.Messages));

                return new ServiceResponse<CommonSchema.SearchResult>(ObjectMapper.Map<CommonSchema.SearchResult>(result.Data), isSuccessful, messages, DateTime.Now);
            }
            catch (Exception ex)
            {
                isSuccessful = false;

                // Add HIPS messages
                messages.AddRange(ObjectMapper.Map<List<ResponseMessage>>(ex));

                return new ServiceResponse<CommonSchema.SearchResult>(null, isSuccessful, messages, DateTime.Now);
            }
        }

        #endregion

    }
}
