﻿using System;

namespace HIPS.Web.Model.Common
{
    /// <summary>
    /// Represents the data for a local document meta-data items from the local document store.
    /// </summary>
    public class LocalClinicalDocumentMetaData
    {
        /// <summary>
        /// Gets or sets the type of the document.
        /// </summary>
        public string DocumentType { get; set; }

        /// <summary>
        /// Gets or sets the date and time of admission for the episode that this document relates to.
        /// </summary>
        public DateTime AdmissionDate { get; set; }

        /// <summary>
        /// Gets or sets the date and time of discharge for the episode that this document relates to.
        /// </summary>
        public DateTime? DischargeDate { get; set; }

        /// <summary>
        /// Gets or sets the Document ID of the document version.
        /// </summary>
        public String SourceSystemDocumentId { get; set; }

        /// <summary>
        /// Gets or sets the Set ID of the document, which is common to all versions of the document.
        /// </summary>
        public String SourceSystemSetId { get; set; }

        /// <summary>
        /// Gets or sets the status of the document within the local repository.
        /// </summary>
        public LocalDocumentStatus Status { get; set; }

        /// <summary>
        /// Gets or sets the date and time when this document version was uploaded to the PCEHR system.
        /// </summary>
        public DateTime? UploadedDate { get; set; }

        /// <summary>
        /// Gets or sets the date and time when this document version was superseded by a newer version uploaded to the PCEHR system.
        /// </summary>
        public DateTime? SupersededDate { get; set; }

        /// <summary>
        /// Gets or sets the family name of the patient's responsible provider for the episode that this document relates to.
        /// </summary>
        public string ResponsibleProviderFamilyName { get; set; }

        /// <summary>
        /// Gets or sets the given names of the patient's responsible provider for the episode that this document relates to.
        /// </summary>
        public string ResponsibleProviderGivenNames { get; set; }

        /// <summary>
        /// Gets or sets the title of the patient's responsible provider (such as 'Dr', 'Ms' or 'Mr') for the episode that this document relates to.
        /// </summary>
        public string ResponsibleProviderTitle { get; set; }

        /// <summary>
        /// Gets or sets the suffix of the patient's responsible provider (such as 'Jr' or 'Sr') for the episode that this document relates to.
        /// </summary>
        public string ResponsibleProviderSuffix { get; set; }

        /// <summary>
        /// Gets or sets the admission reason for the episode that this document relates to.
        /// </summary>
        public string AdmissionReason { get; set; }
    }
}