﻿using System;

namespace HIPS.Web.Model.Directory
{
    /// <summary>
    /// Delegate class.
    /// </summary>
    public class Delegate
    {
        #region Properties

        /// <summary>
        /// Gets or sets the unique identifier of the delegate.
        /// </summary>
        public string QualifiedIdentifier { get; set; }

        /// <summary>
        /// Gets or sets the intermediary of the delegate.
        /// </summary>
        public Intermediary Intermediary { get; set; }

        /// <summary>
        /// Gets or sets the name of the delegate.
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// Gets or sets the additional comments of the delegate.
        /// </summary>
        public string AdditionalComments { get; set; }

        /// <summary>
        /// Gets or sets the priority number of the delegate.
        /// </summary>
        public int PriorityNumber { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether the delegate is active (available for use).
        /// </summary>
        public bool IsActive { get; set; }

        /// <summary>
        /// Gets or sets a date and time value representing the modification timestamp of the entity within its persistence store.
        /// </summary>
        public DateTime Timestamp { get; set; }

        #endregion
    }
}
