﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace HIPS.Web.Model.Hpii
{
    /// <summary>
    /// Local Provider.
    /// </summary>
    public class LocalProvider
    {
        /// <summary>
        /// Gets or sets the identifier provided by eHISC.
        /// </summary>        
        public string LocalProviderCode { get; set; }
        
        /// <summary>
        /// Gets or sets Family Name.
        /// </summary>
        public string FamilyName { get; set; }
        
        /// <summary>
        /// Gets or sets Given Names.
        /// </summary>
        public string GivenNames { get; set; }
        
        /// <summary>
        /// Get or sets Title.
        /// </summary>
        public string Title { get; set; }
        
        /// <summary>
        /// Gets or sets Suffix
        /// </summary>
        public string Suffix { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether state of the provider is active or inactive.
        /// </summary>        
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the HPI-I of the local provider.
        /// </summary>        
        public string Hpii { get; set; }

        /// <summary>
        /// Gets or sets the current status of the providers HPI-I.
        /// </summary>        
        public HpiiStatus HpiiStatus { get; set; }

        /// <summary>
        /// Gets or sets the list of local provider identifiers.
        /// </summary>        
        public List<LocalProviderIdentifier> LocalProviderIdentifiers { get; set; }
    }
}
