﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace HIPS.Web.Model.Messaging
{
    /// <summary>
    /// Individual Name.
    /// </summary>
    public class IndividualName
    {
        /// <summary>
        /// Initialises a new instance of the <see cref="IndividualName"/> class.
        /// </summary>
        public IndividualName()
        {
            this.NameUsage = new List<IndividualNameUsage>();
        }
        
        /// <summary>
        /// Gets or sets the family name of the individual.
        /// </summary>        
        public string FamilyName { get; set; }

        /// <summary>
        /// Gets or sets the given names of the individual, separated by spaces.
        /// </summary>        
        public string GivenNames { get; set; }

        /// <summary>
        /// Gets or sets the titles of the individual, separated by spaces.
        /// </summary>        
        public string Titles { get; set; }

        /// <summary>
        /// Gets or sets the suffixes of the individual, separated by spaces.
        /// </summary>        
        public string Suffixes { get; set; }

        /// <summary>
        /// Gets or sets the alias name of the individual.
        /// </summary>        
        public string KnownAs { get; set; }

        /// <summary>
        /// Gets or sets the list of codes describing how this name is used.
        /// </summary>        
        public List<IndividualNameUsage> NameUsage { get; set; }
    }
}
