﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace HIPS.Web.Model.Messaging
{
    /// <summary>
    /// Transport Response.
    /// </summary>
    public class TransportResponse
    {
        #region Properties

        /// <summary>
        /// Gets or sets the timestamp of the transport response.
        /// </summary>
        public DateTime ResponseTime { get; set; }

        /// <summary>
        /// Gets or sets the class of the transport response.
        /// </summary>
        public TransportResponseClass ResponseClass { get; set; }

        /// <summary>
        /// Gets or sets the status of the transport response.
        /// </summary>
        public TransportResponseStatus ResponseStatus { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether the transport response is final.
        /// </summary>
        public bool Final { get; set; }
       
        /// <summary>
        /// Gets or sets the message associated with the transport response.
        /// </summary>
        public string Message { get; set; }

        #endregion
    }
}
